<?php
/*--------------------------------------------------------------------------------------------------
    InsufficientQuantityException.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Unit\Exceptions;
use Exception;

/**
 * Class InsufficientQuantityException
 */
class InsufficientQuantityException extends Exception
{


    /**
     * InsufficientQuantityException constructor.
     * @param int $productId
     * @param float $availableQuantity
     * @param Exception|null $previous
     */
    public function __construct(int $productId, float $availableQuantity,  ?Exception $previous)
    {
        parent::__construct('', 0, $previous);
    }
}